(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 4.0,
MathReader 4.0, or any compatible application. The data for the notebook 
starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     18550,        464]*)
(*NotebookOutlinePosition[     19393,        491]*)
(*  CellTagsIndexPosition[     19349,        487]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[BoxData[{
    \( (*\ 
      Example\ 6.2  .1 . \[IndentingNewLine]Trapezoidal\ rule\ with\ 12\ \
intervals\ of\ equal\ length\ \[Pi]/
            6\ from\ \n\t\t\t - \[Pi]\ to\ \[Pi]\ \ *) \n\(f[
          t_, \[Tau]_]\  := \ 
        1/\((0.68\  - \ 0.32*Cos[t + \[Tau]])\);\)\), "\n", 
    \(\(y1 + \((1/40)\)*\ \((\ 
              y1*f[0, \(-\[Pi]\)] + 2\ y2*f[0, \(-5\) \[Pi]/6] + \ 
                2\ y3*f[0, \(-2\) \[Pi]/3]\  + \ 2\ y4*f[0, \(-\[Pi]\)/2] + \ 
                2\ y3*f[0, \(-\[Pi]\)/3] + \ 2\ y2*f[0, \(-\[Pi]\)/6] + 
                2\ y1*f[0, 0] + 2\ y2*f[0, \[Pi]/6] + 2\ y3*f[0, \[Pi]/3] + 
                2\ y4*f[0, \[Pi]/2] + 2\ y3*f[0, 2  \[Pi]/3] + 
                2\ y2*f[0, 5  \[Pi]/6] + \ y1*f[0, \[Pi]]\ )\) // N\) // 
      Simplify\)}], "Input"],

Cell[BoxData[
    \(1.18888888888888889`\ y1 + 0.352697095435684637`\ y2 + 
      0.311355311355311359`\ y3 + 0.147058823529411775`\ y4\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\( (*\ This\ is\ lhs\ of\ Eq\ \((1)\)\ \ *) \n
    \(y2 + \((1/40)\)*\ 
            \((\ y1*f[\[Pi]/6, \(-\[Pi]\)] + 
                2\ y2*f[\[Pi]/6, \(-5\) \[Pi]/6] + \ 
                2\ y3*f[\[Pi]/6, \(-2\) \[Pi]/3]\  + \ 
                2\ y4*f[\[Pi]/6, \(-\[Pi]\)/2] + \ 
                2\ y3*f[\[Pi]/6, \(-\[Pi]\)/3] + \ 
                2\ y2*f[\[Pi]/6, \(-\[Pi]\)/6] + 2\ y1*f[\[Pi]/6, 0] + 
                2\ y2*f[\[Pi]/6, \[Pi]/6] + 2\ y3*f[\[Pi]/6, \[Pi]/3] + 
                2\ y4*f[\[Pi]/6, \[Pi]/2] + 2\ y3*f[\[Pi]/6, 2  \[Pi]/3] + 
                2\ y2*f[\[Pi]/6, 5  \[Pi]/6] + \ y1*f[\[Pi]/6, \[Pi]]\ )\) // 
        N\) // \n\t\tSimplify\)\)], "Input"],

Cell[BoxData[
    \(0.176348547717842318`\ y1 + 1.34456654456654445`\ y2 + 
      0.323407371247254049`\ y3 + 0.155677655677655675`\ y4\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\( (*\ This\ is\ lhs\ of\ Eq\ \((2)\)\ \ *) \n
    \(y3 + \((1/40)\)*\ 
            \((\ y1*f[\[Pi]/3, \(-\[Pi]\)] + 
                2\ y2*f[\[Pi]/3, \(-5\) \[Pi]/6] + \ 
                2\ y3*f[\[Pi]/3, \(-2\) \[Pi]/3]\  + \ 
                2\ y4*f[\[Pi]/3, \(-\[Pi]\)/2] + \ 
                2\ y3*f[\[Pi]/3, \(-\[Pi]\)/3] + \ 
                2\ y2*f[\[Pi]/3, \(-\[Pi]\)/6] + 2\ y1*f[\[Pi]/3, 0] + 
                2\ y2*f[\[Pi]/3, \[Pi]/6] + 2\ y3*f[\[Pi]/3, \[Pi]/3] + 
                2\ y4*f[\[Pi]/3, \[Pi]/2] + 2\ y3*f[\[Pi]/3, 2  \[Pi]/3] + 
                2\ y2*f[\[Pi]/3, 5  \[Pi]/6] + \ y1*f[\[Pi]/3, \[Pi]]\ )\) // 
        N\) // \n\t\tSimplify\)\)], "Input"],

Cell[BoxData[
    \(0.155677655677655675`\ y1 + 0.323407371247254049`\ y2 + 
      1.34456654456654445`\ y3 + 0.176348547717842318`\ y4\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\( (*\ This\ is\ lhs\ of\ Eq\ \((3)\)\ \ *) \n
    \(y4 + \((1/40)\)*\ 
            \((\ y1*f[\[Pi]/2, \(-\[Pi]\)] + 
                2\ y2*f[\[Pi]/2, \(-5\) \[Pi]/6] + \ 
                2\ y3*f[\[Pi]/2, \(-2\) \[Pi]/3]\  + \ 
                2\ y4*f[\[Pi]/2, \(-\[Pi]\)/2] + \ 
                2\ y3*f[\[Pi]/2, \(-\[Pi]\)/3] + \ 
                2\ y2*f[\[Pi]/2, \(-\[Pi]\)/6] + 2\ y1*f[\[Pi]/2, 0] + 
                2\ y2*f[\[Pi]/2, \[Pi]/6] + 2\ y3*f[\[Pi]/2, \[Pi]/3] + 
                2\ y4*f[\[Pi]/2, \[Pi]/2] + 2\ y3*f[\[Pi]/2, 2  \[Pi]/3] + 
                2\ y2*f[\[Pi]/2, 5  \[Pi]/6] + \ y1*f[\[Pi]/2, \[Pi]]\ )\) // 
        N\) // \n\t\tSimplify\)\)], "Input"],

Cell[BoxData[
    \(0.147058823529411775`\ y1 + 0.311355311355311359`\ y2 + 
      0.352697095435684637`\ y3 + 1.18888888888888889`\ y4\)], "Output"]
}, Open  ]],

Cell[BoxData[
    \( (*\ \ This\ is\ lhs\ of\ Eq\ \((4)\)\ \ *) \)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\( (*\ Now\ to\ solve\ the\ four\ equations\ *) \n
    NSolve[{1.18888888888888889`\ y1 + 0.352697095435684637`\ y2 + 
            0.311355311355311359`\ y3 + 0.147058823529411775`\ y4 == \ 25, \n
        \t0.176348547717842318`\ y1 + 1.34456654456654445`\ y2 + 
            0.323407371247254049`\ y3 + 0.155677655677655675`\ y4 == \ 21, \n
        0.155677655677655675`\ y1 + 0.323407371247254049`\ y2 + 
            1.34456654456654445`\ y3 + 0.176348547717842318`\ y4 == \ 13, \n
        0.147058823529411775`\ y1 + 0.311355311355311359`\ y2 + 
            0.352697095435684637`\ y3 + 1.18888888888888889`\ y4 == \ 9}, 
      \ {y1, y2, y3, y4}]\n\)\)], "Input"],

Cell[BoxData[
    \({{y1 \[Rule] 16.0294044734548286`, y2 \[Rule] 12.2647019834076731`, 
        y3 \[Rule] 4.73529700331336567`, y4 \[Rule] 0.970594513266210334`}}
      \)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Solve[\n
      \t{a0 + a1 + a2 + a3 == \ y1, \n\t\ta0 + a1/2 - a2/2 - a3 == y2, \n\t\t
        a0 - a1/2 - a2/2 + a3 == \ y3, \n\t\ta0 - a1 + a2 - a3 == \ y4}, {a0, 
        a1, a2, a3}]\)], "Input"],

Cell[BoxData[
    \({{a0 \[Rule] 1\/6\ \((y1 + 2\ y2 + 2\ y3 + y4)\), 
        a1 \[Rule] 1\/3\ \((y1 + y2 - y3 - y4)\), 
        a2 \[Rule] 1\/3\ \((y1 - y2 - y3 + y4)\), 
        a3 \[Rule] 1\/6\ \((y1 - 2\ y2 + 2\ y3 - y4)\)}}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Solve[\n
      \t{a0 + a1 + a2 + a3 == \ 16.0294044734548286`, \n\t\t
        a0 + a1/2 - a2/2 - a3 == 12.2647019834076731`, \n\t\t
        a0 - a1/2 - a2/2 + a3 == \ 4.73529700331336567`, \n\t\t
        a0 - a1 + a2 - a3 == \ 0.970594513266210334`}, {a0, a1, a2, a3}]\)], 
  "Input"],

Cell[BoxData[
    \({{a0 \[Rule] 8.4999994933605194`, a1 \[Rule] 7.52940498009430836`, 
        a2 \[Rule] 0.`, a3 \[Rule] 1.18423789293350001`*^-15}}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
    \( (*\ 
      Rectangular\ formula\ with\ 12\ intervals\ of\ equal\ length\ \[Pi]/
            6\ from\ \n\t\t\t - \[Pi]\ to\ \[Pi]\ \ *) \n\(f[
          t_, \[Tau]_]\  := \ 
        1/\((0.68\  - \ 0.32*Cos[t + \[Tau]])\);\)\), "\n", 
    \(\(y1 + \((1/20)\)*\ \((\ 
              y1*f[0, \(-\[Pi]\)] + \ 
                y2*f[0, \(-5\) \[Pi]/6] + \ \ y3*
                  f[0, \(-2\) \[Pi]/3]\  + \ \ y4*f[0, \(-\[Pi]\)/2] + \ \ y3*
                  f[0, \(-\[Pi]\)/3] + \ y2*f[0, \(-\[Pi]\)/6] + 
                y1*f[0, 0] + \ y2*f[0, \[Pi]/6] + \ y3*f[0, \[Pi]/3] + \ 
                y4*f[0, \[Pi]/2] + \ y3*f[0, 2  \[Pi]/3] + \ 
                y2*f[0, 5  \[Pi]/6]\ )\) // N\) // Simplify\)}], "Input"],

Cell[BoxData[
    \(1.1888888888888889`\ y1 + 0.3526970954356846`\ y2 + 
      0.31135531135531136`\ y3 + 0.14705882352941177`\ y4\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(\( (*\ 
      This\ is\ lhs\ of\ Eq\ \((1)\)\ \ *) \)\(\n\)\(\(y2 + \((1/20)\)*\ \((\ 
              y1*f[\[Pi]/6, \(-\[Pi]\)] + \ 
                y2*f[\[Pi]/6, \(-5\) \[Pi]/6] + \ \ y3*
                  f[\[Pi]/6, \(-2\) \[Pi]/3]\  + \ \ y4*
                  f[\[Pi]/6, \(-\[Pi]\)/2] + \ \ y3*
                  f[\[Pi]/6, \(-\[Pi]\)/3] + \ \ y2*
                  f[\[Pi]/6, \(-\[Pi]\)/6] + \ y1*f[\[Pi]/6, 0] + \ 
                y2*f[\[Pi]/6, \[Pi]/6] + \ y3*f[\[Pi]/6, \[Pi]/3] + \ 
                y4*f[\[Pi]/6, \[Pi]/2] + \ y3*f[\[Pi]/6, 2  \[Pi]/3] + \ 
                y2*f[\[Pi]/6, 5  \[Pi]/6]\ )\) // 
        N\) // \n\t\tSimplify\)\)\)], "Input"],

Cell[BoxData[
    \(0.1763485477178423`\ y1 + 1.3445665445665445`\ y2 + 
      0.32340737124725405`\ y3 + 0.15567765567765568`\ y4\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(\( (*\ 
      This\ is\ lhs\ of\ Eq\ \((2)\)\ \ *) \)\(\n\)\(\(y3 + \((1/20)\)*\ \((\ 
              y1*f[\[Pi]/3, \(-\[Pi]\)] + \ 
                y2*f[\[Pi]/3, \(-5\) \[Pi]/6] + \ \ y3*
                  f[\[Pi]/3, \(-2\) \[Pi]/3]\  + \ \ y4*
                  f[\[Pi]/3, \(-\[Pi]\)/2] + \ \ y3*
                  f[\[Pi]/3, \(-\[Pi]\)/3] + \ \ y2*
                  f[\[Pi]/3, \(-\[Pi]\)/6] + \ y1*f[\[Pi]/3, 0] + \ 
                y2*f[\[Pi]/3, \[Pi]/6] + \ y3*f[\[Pi]/3, \[Pi]/3] + \ 
                y4*f[\[Pi]/3, \[Pi]/2] + \ y3*f[\[Pi]/3, 2  \[Pi]/3] + \ 
                y2*f[\[Pi]/3, 5  \[Pi]/6]\ )\) // 
        N\) // \n\t\tSimplify\)\)\)], "Input"],

Cell[BoxData[
    \(0.15567765567765568`\ y1 + 0.32340737124725405`\ y2 + 
      1.3445665445665445`\ y3 + 0.1763485477178423`\ y4\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(\( (*\ 
      This\ is\ lhs\ of\ Eq\ \((3)\)\ \ *) \)\(\n\)\(\(y4 + \((1/20)\)*\ \((\ 
              y1*f[\[Pi]/2, \(-\[Pi]\)] + \ 
                y2*f[\[Pi]/2, \(-5\) \[Pi]/6] + \ \ y3*
                  f[\[Pi]/2, \(-2\) \[Pi]/3]\  + \ \ y4*
                  f[\[Pi]/2, \(-\[Pi]\)/2] + \ \ y3*
                  f[\[Pi]/2, \(-\[Pi]\)/3] + \ \ y2*
                  f[\[Pi]/2, \(-\[Pi]\)/6] + \ y1*f[\[Pi]/2, 0] + \ 
                y2*f[\[Pi]/2, \[Pi]/6] + \ y3*f[\[Pi]/2, \[Pi]/3] + \ 
                y4*f[\[Pi]/2, \[Pi]/2] + \ y3*f[\[Pi]/2, 2  \[Pi]/3] + \ 
                y2*f[\[Pi]/2, 5  \[Pi]/6]\ )\) // 
        N\) // \n\t\tSimplify\)\)\)], "Input"],

Cell[BoxData[
    \(0.14705882352941177`\ y1 + 0.31135531135531136`\ y2 + 
      0.3526970954356846`\ y3 + 1.1888888888888889`\ y4\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(\( (*\ \ This\ is\ lhs\ of\ Eq\ \((4)\)\ \ *) \)\( (*\ 
      Now\ to\ solve\ the\ four\ equations\ *) \)\(\n\
\)\(NSolve[{1.18888888888888889`\ y1 + 0.352697095435684637`\ y2 + 
            0.311355311355311359`\ y3 + 0.147058823529411775`\ y4 == \ 25, \n
        0.176348547717842318`\ y1 + 1.34456654456654445`\ y2 + 
            0.323407371247254049`\ y3 + 0.155677655677655675`\ y4 == \ 21, \n
        0.155677655677655675`\ y1 + 0.323407371247254049`\ y2 + 
            1.34456654456654445`\ y3 + 0.176348547717842318`\ y4 == \ 13, \n
        0.147058823529411775`\ y1 + 0.311355311355311359`\ y2 + 
            0.352697095435684637`\ y3 + 1.18888888888888889`\ y4 == \ 
          9}, \ {y1, y2, y3, y4}]\)\)\)], "Input"],

Cell[BoxData[
    \({{y1 \[Rule] 16.02940447345483`, y2 \[Rule] 12.264701983407672`, 
        y3 \[Rule] 4.735297003313366`, 
        y4 \[Rule] 0.9705945132662104`}}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Solve[\n\t{a0 + a1 + a2 + a3 == \ y1, \n\t\ta0 + a1/2 - a2/2 - a3 == 
          y2, \n\t\ta0 - a1/2 - a2/2 + a3 == \ 
          y3, \n\t\ta0 - a1 + a2 - a3 == \ y4}, {a0, a1, a2, a3}]\)], "Input"],

Cell[BoxData[
    \({{a0 \[Rule] 1\/6\ \((y1 + 2\ y2 + 2\ y3 + y4)\), 
        a1 \[Rule] 1\/3\ \((y1 + y2 - y3 - y4)\), 
        a2 \[Rule] 1\/3\ \((y1 - y2 - y3 + y4)\), 
        a3 \[Rule] 1\/6\ \((y1 - 2\ y2 + 2\ y3 - y4)\)}}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Solve[\n\t{a0 + a1 + a2 + a3 == \ 
          16.0294044734548286`, \n\t\ta0 + a1/2 - a2/2 - a3 == 
          12.2647019834076731`, \n\t\ta0 - a1/2 - a2/2 + a3 == \ 
          4.73529700331336567`, \n\t\ta0 - a1 + a2 - a3 == 
          0.970594513266210334`}, {a0, a1, a2, a3}]\)], "Input"],

Cell[BoxData[
    \({{a0 \[Rule] 8.49999949336052`, a1 \[Rule] 7.529404980094308`, 
        a2 \[Rule] 0.`, a3 \[Rule] 1.1842378929335002`*^-15}}\)], "Output"]
}, Open  ]],

Cell[BoxData[
    \(\(\( (*\ 
      Simpson' s\ rule\ with\ 12\ intervals\ of\ \n\t\tequal\ length\ \[Pi]/
            6\ from\  - \[Pi]\ to\ \[Pi]\ \ *) \)\(\n\)\(f[
          t_, \[Tau]_]\  := \ 
        1/\((0.68\  - \ 0.32*Cos[t + \[Tau]])\);\)\)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(y1 + \((1/60)\)*\ \((\ 
              y1*f[0, \(-\[Pi]\)] + 4\ y2*f[0, \(-5\) \[Pi]/6] + \ 
                2\ y3*f[0, \(-2\) \[Pi]/3]\  + \ 4\ y4*f[0, \(-\[Pi]\)/2] + \ 
                2\ y3*f[0, \(-\[Pi]\)/3] + \ 4\ y2*f[0, \(-\[Pi]\)/6] + 
                2\ y1*f[0, 0] + 4\ y2*f[0, \[Pi]/6] + 2\ y3*f[0, \[Pi]/3] + 
                4\ y4*f[0, \[Pi]/2] + 2\ y3*f[0, 2  \[Pi]/3] + 
                4\ y2*f[0, 5  \[Pi]/6] + \ y1*f[0, \[Pi]]\ )\) // N\) // 
      Simplify\)], "Input"],

Cell[BoxData[
    \(1.125925925925926`\ y1 + 0.47026279391424614`\ y2 + 
      0.20757020757020753`\ y3 + 0.196078431372549`\ y4\)], "Output"]
}, Open  ]],

Cell[BoxData[
    \( (*\ This\ is\ lhs\ of\ Eq\ \((1)\)\ \ *) \)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(y2 + \((1/60)\)*\ \((\ 
              y1*f[\[Pi]/6, \(-\[Pi]\)] + 
                4\ y2*f[\[Pi]/6, \(-5\) \[Pi]/6] + \ 
                2\ y3*f[\[Pi]/6, \(-2\) \[Pi]/3]\  + \ 
                4\ y4*f[\[Pi]/6, \(-\[Pi]\)/2] + \ 
                2\ y3*f[\[Pi]/6, \(-\[Pi]\)/3] + \ 
                4\ y2*f[\[Pi]/6, \(-\[Pi]\)/6] + 2\ y1*f[\[Pi]/6, 0] + 
                4\ y2*f[\[Pi]/6, \[Pi]/6] + 2\ y3*f[\[Pi]/6, \[Pi]/3] + 
                4\ y4*f[\[Pi]/6, \[Pi]/2] + 2\ y3*f[\[Pi]/6, 2  \[Pi]/3] + 
                4\ y2*f[\[Pi]/6, 5  \[Pi]/6] + \ y1*f[\[Pi]/6, \[Pi]]\ )\) // 
        N\) // \n\t\tSimplify\)], "Input"],

Cell[BoxData[
    \(0.11756569847856153`\ y1 + 1.4594220594220593`\ y2 + 
      0.21560491416483604`\ y3 + 0.20757020757020753`\ y4\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(\( (*\ 
      This\ is\ lhs\ of\ Eq\ \((2)\)\ \ *) \)\(\(y3 + \((1/60)\)*\ \((\ 
              y1*f[\[Pi]/3, \(-\[Pi]\)] + 
                4\ y2*f[\[Pi]/3, \(-5\) \[Pi]/6] + \ 
                2\ y3*f[\[Pi]/3, \(-2\) \[Pi]/3]\  + \ 
                4\ y4*f[\[Pi]/3, \(-\[Pi]\)/2] + \ 
                2\ y3*f[\[Pi]/3, \(-\[Pi]\)/3] + \ 
                4\ y2*f[\[Pi]/3, \(-\[Pi]\)/6] + 2\ y1*f[\[Pi]/3, 0] + 
                4\ y2*f[\[Pi]/3, \[Pi]/6] + 2\ y3*f[\[Pi]/3, \[Pi]/3] + 
                4  y4*f[\[Pi]/3, \[Pi]/2] + 2\ y3*f[\[Pi]/3, 2  \[Pi]/3] + 
                4\ y2*f[\[Pi]/3, 5  \[Pi]/6] + \ y1*f[\[Pi]/3, \[Pi]]\ )\) // 
        N\) // \n\t\tSimplify\)\)\)], "Input"],

Cell[BoxData[
    \(0.10378510378510376`\ y1 + 0.4312098283296721`\ y2 + 
      1.2297110297110296`\ y3 + 0.23513139695712307`\ y4\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(\( (*\ \ This\ is\ lhs\ of\ Eq\ \((3)\)\ \ *) \)\(\(y4 + \((1/
                40)\)*\ \((\ 
              y1*f[\[Pi]/2, \(-\[Pi]\)] + 
                4\ y2*f[\[Pi]/2, \(-5\) \[Pi]/6] + \ 
                2\ y3*f[\[Pi]/2, \(-2\) \[Pi]/3]\  + \ 
                4\ y4*f[\[Pi]/2, \(-\[Pi]\)/2] + \ 
                2\ y3*f[\[Pi]/2, \(-\[Pi]\)/3] + \ 
                4\ y2*f[\[Pi]/2, \(-\[Pi]\)/6] + 2\ y1*f[\[Pi]/2, 0] + 
                4\ y2*f[\[Pi]/2, \[Pi]/6] + 2\ y3*f[\[Pi]/2, \[Pi]/3] + 
                4\ y4*f[\[Pi]/2, \[Pi]/2] + 2\ y3*f[\[Pi]/2, 2  \[Pi]/3] + 
                4\ y2*f[\[Pi]/2, 5  \[Pi]/6] + \ y1*f[\[Pi]/2, \[Pi]]\ )\) // 
        N\) // \n\t\tSimplify\)\)\)], "Input"],

Cell[BoxData[
    \(0.14705882352941177`\ y1 + 0.6227106227106227`\ y2 + 
      0.3526970954356846`\ y3 + 1.3777777777777778`\ y4\)], "Output"]
}, Open  ]],

Cell[BoxData[
    \( (*\ \ This\ is\ lhs\ of\ Eq\ \((4)\)\ \ *) \)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(\( (*\ 
      Now\ to\ solve\ the\ four\ equations\ *) \)\(\n\
\)\(NSolve[{1.12592592592592599`\ y1 + 0.470262793914246124`\ y2 + 
            0.207570207570207543`\ y3 + 0.196078431372548998`\ y4 == \ 
          25, \n\t0.117565698478561531`\ y1 + 1.45942205942205927`\ y2 + 
            0.215604914164836047`\ y3 + 0.207570207570207543`\ y4 == \ 21, \n
        0.103785103785103771`\ y1 + 0.431209828329672095`\ y2 + 
            1.22971102971102963`\ y3 + 0.235131396957123062`\ y4 == \ 13, \n
        0.147058823529411775`\ y1 + 0.622710622710622718`\ y2 + 
            0.352697095435684637`\ y3 + 1.37777777777777776`\ y4 == \ 
          9}, \ {y1, y2, y3, y4}]\)\)\)], "Input"],

Cell[BoxData[
    \({{y1 \[Rule] 16.365740450135032`, y2 \[Rule] 12.623530016060307`, 
        y3 \[Rule] 5.193932414048641`, 
        y4 \[Rule] \(-2.2495773267696224`\)}}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Solve[\n\t{a0 + a1 + a2 + a3 == \ y1, \n\t\ta0 + a1/2 - a2/2 - a3 == 
          y2, \n\t\ta0 - a1/2 - a2/2 + a3 == \ 
          y3, \n\t\ta0 - a1 + a2 - a3 == \ y4}, {a0, a1, a2, a3}]\)], "Input"],

Cell[BoxData[
    \({{a0 \[Rule] 1\/6\ \((y1 + 2\ y2 + 2\ y3 + y4)\), 
        a1 \[Rule] 1\/3\ \((y1 + y2 - y3 - y4)\), 
        a2 \[Rule] 1\/3\ \((y1 - y2 - y3 + y4)\), 
        a3 \[Rule] 1\/6\ \((y1 - 2\ y2 + 2\ y3 - y4)\)}}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Solve[\n\t{a0 + a1 + a2 + a3 == \ 
          16.3657404501350312`, \n\t\ta0 + a1/2 - a2/2 - a3 == 
          12.623530016060307`, \n\t\ta0 - a1/2 - a2/2 + a3 == \ 
          5.19393241404864092`, \n\t\ta0 - a1 + a2 - 
            a3 == \ \(-2.2495773267696224`\)}, {a0, a1, a2, a3}]\)], "Input"],

Cell[BoxData[
    \({{a0 \[Rule] 8.291847997263883`, a1 \[Rule] 8.681638459638773`, 
        a2 \[Rule] \(-1.2337664355811793`\), 
        a3 \[Rule] 0.6260204288135534`}}\)], "Output"]
}, Open  ]]
},
FrontEndVersion->"4.0 for Macintosh",
ScreenRectangle->{{0, 832}, {0, 604}},
WindowSize->{520, 509},
WindowMargins->{{4, Automatic}, {Automatic, -2}},
MacintoshSystemPageSetup->"\<\
00<0001804P000000]P2:?oQon82n@960dL5:0?l0080001804P000000]P2:001
0000I00000400`<300000BL?00400@0000000000000006P801T1T00000000000
00000000000000000000000000000000\>"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1739, 51, 788, 14, 219, "Input"],
Cell[2530, 67, 149, 2, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[2716, 74, 696, 12, 187, "Input"],
Cell[3415, 88, 149, 2, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[3601, 95, 696, 12, 187, "Input"],
Cell[4300, 109, 149, 2, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[4486, 116, 696, 12, 187, "Input"],
Cell[5185, 130, 149, 2, 26, "Output"]
}, Open  ]],
Cell[5349, 135, 77, 1, 27, "Input"],

Cell[CellGroupData[{
Cell[5451, 140, 685, 10, 251, "Input"],
Cell[6139, 152, 185, 3, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[6361, 160, 219, 4, 91, "Input"],
Cell[6583, 166, 243, 4, 76, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[6863, 175, 304, 6, 107, "Input"],
Cell[7170, 183, 164, 2, 28, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[7371, 190, 731, 13, 187, "Input"],
Cell[8105, 205, 144, 2, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[8286, 212, 684, 12, 171, "Input"],
Cell[8973, 226, 144, 2, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[9154, 233, 684, 12, 171, "Input"],
Cell[9841, 247, 144, 2, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[10022, 254, 684, 12, 171, "Input"],
Cell[10709, 268, 144, 2, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[10890, 275, 749, 11, 251, "Input"],
Cell[11642, 288, 180, 3, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[11859, 296, 216, 3, 91, "Input"],
Cell[12078, 301, 243, 4, 76, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[12358, 310, 309, 5, 107, "Input"],
Cell[12670, 317, 159, 2, 28, "Output"]
}, Open  ]],
Cell[12844, 322, 263, 5, 59, "Input"],

Cell[CellGroupData[{
Cell[13132, 331, 508, 8, 139, "Input"],
Cell[13643, 341, 142, 2, 26, "Output"]
}, Open  ]],
Cell[13800, 346, 75, 1, 27, "Input"],

Cell[CellGroupData[{
Cell[13900, 351, 645, 11, 171, "Input"],
Cell[14548, 364, 145, 2, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[14730, 371, 706, 12, 187, "Input"],
Cell[15439, 385, 144, 2, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[15620, 392, 718, 12, 187, "Input"],
Cell[16341, 406, 143, 2, 26, "Output"]
}, Open  ]],
Cell[16499, 411, 77, 1, 27, "Input"],

Cell[CellGroupData[{
Cell[16601, 416, 705, 11, 235, "Input"],
Cell[17309, 429, 186, 3, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[17532, 437, 216, 3, 91, "Input"],
Cell[17751, 442, 243, 4, 76, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[18031, 451, 315, 5, 107, "Input"],
Cell[18349, 458, 185, 3, 26, "Output"]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

